<?php
require_once '../includes/database.php';
require_once '../includes/auth.php';

header('Content-Type: application/json');

$database = new Database();
$auth = new Auth($database);

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'POST':
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (isset($_GET['action'])) {
            switch ($_GET['action']) {
                case 'register':
                    if (!isset($data['email']) || !isset($data['password'])) {
                        http_response_code(400);
                        echo json_encode(['success' => false, 'message' => 'البريد الإلكتروني وكلمة المرور مطلوبان']);
                        exit;
                    }
                    
                    $result = $auth->register($data['email'], $data['password']);
                    echo json_encode($result);
                    break;
                    
                case 'login':
                    if (!isset($data['email']) || !isset($data['password'])) {
                        http_response_code(400);
                        echo json_encode(['success' => false, 'message' => 'البريد الإلكتروني وكلمة المرور مطلوبان']);
                        exit;
                    }
                    
                    $result = $auth->login($data['email'], $data['password']);
                    echo json_encode($result);
                    break;
                    
                default:
                    http_response_code(404);
                    echo json_encode(['success' => false, 'message' => 'الإجراء غير معروف']);
            }
        } else {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'الإجراء مطلوب']);
        }
        break;
        
    default:
        http_response_code(405);
        echo json_encode(['success' => false, 'message' => 'الطريقة غير مسموحة']);
}
?>