<?php
require_once '../includes/database.php';
require_once '../includes/auth.php';

header('Content-Type: application/json');

$database = new Database();
$auth = new Auth($database);
$db = $database->getConnection();

// التحقق من المصادقة
$headers = getallheaders();
$token = isset($headers['Authorization']) ? str_replace('Bearer ', '', $headers['Authorization']) : null;

if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'التوكن مطلوب']);
    exit;
}

$user = $auth->getUserFromToken($token);
if (!$user) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'توكن غير صالح']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        if (isset($_GET['id'])) {
            // الحصول على محادثة محددة
            $conversationId = $_GET['id'];
            
            $stmt = $db->prepare("
                SELECT m.* 
                FROM messages m 
                JOIN conversations c ON m.conversation_id = c.id 
                WHERE c.id = ? AND c.user_id = ?
                ORDER BY m.created_at ASC
            ");
            $stmt->execute([$conversationId, $user['id']]);
            $messages = $stmt->fetchAll();
            
            if (!$messages) {
                http_response_code(404);
                echo json_encode(['success' => false, 'message' => 'المحادثة غير موجودة']);
                exit;
            }
            
            echo json_encode([
                'success' => true,
                'conversation_id' => $conversationId,
                'messages' => $messages
            ]);
            
        } else {
            // الحصول على قائمة المحادثات
            $stmt = $db->prepare("
                SELECT c.id, c.created_at, 
                       (SELECT original_text FROM messages WHERE conversation_id = c.id AND sender = 'user' ORDER BY created_at ASC LIMIT 1) as first_message
                FROM conversations c 
                WHERE c.user_id = ?
                ORDER BY c.created_at DESC
            ");
            $stmt->execute([$user['id']]);
            $conversations = $stmt->fetchAll();
            
            echo json_encode([
                'success' => true,
                'conversations' => $conversations
            ]);
        }
        break;
        
    default:
        http_response_code(405);
        echo json_encode(['success' => false, 'message' => 'الطريقة غير مسموحة']);
}
?>