<?php
require_once '../includes/database.php';
require_once '../includes/auth.php';
require_once '../includes/openai.php';
require_once '../includes/stt.php';
require_once '../includes/tts.php';

header('Content-Type: application/json');

$database = new Database();
$auth = new Auth($database);
$db = $database->getConnection();

// التحقق من المصادقة
$headers = getallheaders();
$token = isset($headers['Authorization']) ? str_replace('Bearer ', '', $headers['Authorization']) : null;

if (!$token) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'التوكن مطلوب']);
    exit;
}

$user = $auth->getUserFromToken($token);
if (!$user) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'توكن غير صالح']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'POST':
        if (isset($_GET['type']) && $_GET['type'] === 'text') {
            // معالجة الرسالة النصية
            $data = json_decode(file_get_contents('php://input'), true);
            
            if (!isset($data['message_text'])) {
                http_response_code(400);
                echo json_encode(['success' => false, 'message' => 'نص الرسالة مطلوب']);
                exit;
            }
            
            // الحصول على آخر محادثة أو إنشاء جديدة
            $stmt = $db->prepare("SELECT id FROM conversations WHERE user_id = ? ORDER BY created_at DESC LIMIT 1");
            $stmt->execute([$user['id']]);
            $conversation = $stmt->fetch();
            
            if (!$conversation) {
                $stmt = $db->prepare("INSERT INTO conversations (user_id) VALUES (?)");
                $stmt->execute([$user['id']]);
                $conversationId = $db->lastInsertId();
            } else {
                $conversationId = $conversation['id'];
            }
            
            // حفظ رسالة المستخدم
            $stmt = $db->prepare("INSERT INTO messages (conversation_id, sender, original_type, original_text, bot_response) VALUES (?, 'user', 'text', ?, '')");
            $stmt->execute([$conversationId, $data['message_text']]);
            $messageId = $db->lastInsertId();
            
            // الحصول على تاريخ المحادثة للإرسال إلى ChatGPT
            $stmt = $db->prepare("SELECT sender, original_text as text FROM messages WHERE conversation_id = ? AND id != ? ORDER BY created_at DESC LIMIT 10");
            $stmt->execute([$conversationId, $messageId]);
            $history = array_reverse($stmt->fetchAll());
            
            // إرسال إلى ChatGPT
            $openai = new OpenAI();
            $botResponse = $openai->sendMessage($data['message_text'], $history);
            
            // حفظ رد البوت
            $stmt = $db->prepare("UPDATE messages SET bot_response = ? WHERE id = ?");
            $stmt->execute([$botResponse, $messageId]);
            
            echo json_encode([
                'success' => true,
                'conversation_id' => $conversationId,
                'bot_response' => $botResponse,
                'response_media_path' => null
            ]);
            
        } else {
            // معالجة ملف الوسائط
            if (!isset($_FILES['media']) || !isset($_POST['type'])) {
                http_response_code(400);
                echo json_encode(['success' => false, 'message' => 'ملف الوسائط والنوع مطلوبان']);
                exit;
            }
            
            $file = $_FILES['media'];
            $type = $_POST['type'];
            
            // التحقق من نوع الملف
            if ($type === 'audio' && !in_array($file['type'], ALLOWED_AUDIO_TYPES)) {
                http_response_code(400);
                echo json_encode(['success' => false, 'message' => 'نوع الملف الصوتي غير مسموح']);
                exit;
            }
            
            if ($type === 'video' && !in_array($file['type'], ALLOWED_VIDEO_TYPES)) {
                http_response_code(400);
                echo json_encode(['success' => false, 'message' => 'نوع ملف الفيديو غير مسموح']);
                exit;
            }
            
            // إنشاء مجلد المستخدم إذا لم يكن موجوداً
            $userDir = UPLOAD_DIR . $user['id'] . '/';
            if (!is_dir($userDir)) {
                mkdir($userDir, 0777, true);
            }
            
            // حفظ الملف
            $fileName = uniqid() . '_' . $file['name'];
            $filePath = $userDir . $fileName;
            
            if (!move_uploaded_file($file['tmp_name'], $filePath)) {
                http_response_code(500);
                echo json_encode(['success' => false, 'message' => 'فشل في حفظ الملف']);
                exit;
            }
            
            // الحصول على آخر محادثة أو إنشاء جديدة
            $stmt = $db->prepare("SELECT id FROM conversations WHERE user_id = ? ORDER BY created_at DESC LIMIT 1");
            $stmt->execute([$user['id']]);
            $conversation = $stmt->fetch();
            
            if (!$conversation) {
                $stmt = $db->prepare("INSERT INTO conversations (user_id) VALUES (?)");
                $stmt->execute([$user['id']]);
                $conversationId = $db->lastInsertId();
            } else {
                $conversationId = $conversation['id'];
            }
            
            // تحويل الصوت إلى نص
            $stt = new SpeechToText();
            $transcribedText = $stt->transcribe($filePath);
            
            // حفظ رسالة المستخدم
            $stmt = $db->prepare("INSERT INTO messages (conversation_id, sender, original_type, media_path, transcribed_text, bot_response) VALUES (?, 'user', ?, ?, ?, '')");
            $stmt->execute([$conversationId, $type, $filePath, $transcribedText]);
            $messageId = $db->lastInsertId();
            
            // الحصول على تاريخ المحادثة
            $stmt = $db->prepare("SELECT sender, COALESCE(transcribed_text, original_text) as text FROM messages WHERE conversation_id = ? AND id != ? ORDER BY created_at DESC LIMIT 10");
            $stmt->execute([$conversationId, $messageId]);
            $history = array_reverse($stmt->fetchAll());
            
            // إرسال إلى ChatGPT
            $openai = new OpenAI();
            $botResponse = $openai->sendMessage($transcribedText, $history);
            
            // تحويل الرد إلى صوت إذا طُلب
            $responseMediaPath = null;
            if (isset($_POST['generate_audio']) && $_POST['generate_audio'] === 'true') {
                $tts = new TextToSpeech();
                $audioData = $tts->generate($botResponse);
                
                if ($audioData) {
                    $audioFileName = 'response_' . uniqid() . '.mp3';
                    $audioFilePath = $userDir . $audioFileName;
                    file_put_contents($audioFilePath, $audioData);
                    $responseMediaPath = $audioFilePath;
                }
            }
            
            // حفظ رد البوت
            $stmt = $db->prepare("UPDATE messages SET bot_response = ?, response_media_path = ? WHERE id = ?");
            $stmt->execute([$botResponse, $responseMediaPath, $messageId]);
            
            echo json_encode([
                'success' => true,
                'conversation_id' => $conversationId,
                'transcribed_text' => $transcribedText,
                'bot_response' => $botResponse,
                'response_media_path' => $responseMediaPath
            ]);
        }
        break;
        
    default:
        http_response_code(405);
        echo json_encode(['success' => false, 'message' => 'الطريقة غير مسموحة']);
}
?>