<?php
require_once 'config.php';

class SpeechToText {
    private $apiKey;
    
    public function __construct($apiKey = null) {
        $this->apiKey = $apiKey ?: OPENAI_API_KEY;
    }
    
    // تحويل الصوت إلى نص
    public function transcribe($audioFilePath) {
        if (empty($this->apiKey)) {
            // إذا لم يكن هناك مفتاح API، نرجع نص تجريبي
            return $this->getMockTranscription();
        }
        
        if (!file_exists($audioFilePath)) {
            throw new Exception("ملف الصوت غير موجود: " . $audioFilePath);
        }
        
        $postFields = [
            'file' => new CURLFile($audioFilePath),
            'model' => 'whisper-1',
            'response_format' => 'json'
        ];
        
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => OPENAI_BASE_URL . '/audio/transcriptions',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $postFields,
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer ' . $this->apiKey
            ]
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode !== 200) {
            error_log("OpenAI STT Error: HTTP $httpCode - $response");
            return "تعذر تحويل الصوت إلى نص. الرجاء المحاولة مرة أخرى.";
        }
        
        $responseData = json_decode($response, true);
        
        return $responseData['text'] ?? "لم أستطع فهم المحتوى الصوتي.";
    }
    
    // نص تجريبي عندما لا يكون هناك مفتاح API
    private function getMockTranscription() {
        $transcriptions = [
            "هذا هو نص تجريبي من تحويل الصوت إلى نص.",
            "لقد قمت بتسجيل صوتي وأريد تحويله إلى نص.",
            "مرحباً، هذا اختبار لنظام تحويل الصوت إلى نص.",
            "أنا أتحدث باللغة العربية وأريد تحويل كلامي إلى نص.",
            "هذا演示 لنظام الذكاء الاصطناعي للتعرف على الكلام."
        ];
        
        return $transcriptions[array_rand($transcriptions)];
    }
}
?>