<?php
require_once 'config.php';

class TextToSpeech {
    private $apiKey;
    
    public function __construct($apiKey = null) {
        $this->apiKey = $apiKey ?: OPENAI_API_KEY;
    }
    
    // تحويل النص إلى كلام
    public function generate($text, $voice = 'alloy') {
        if (empty($this->apiKey)) {
            // إذا لم يكن هناك مفتاح API، نرجع null
            return null;
        }
        
        $data = [
            'model' => 'tts-1',
            'input' => $text,
            'voice' => $voice,
            'response_format' => 'mp3'
        ];
        
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => OPENAI_BASE_URL . '/audio/speech',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $this->apiKey
            ]
        ]);
        
        $audioData = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode !== 200) {
            error_log("OpenAI TTS Error: HTTP $httpCode");
            return null;
        }
        
        return $audioData;
    }
}
?>